/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.IntBox;

public abstract class NetherPortalLikeForm
extends PortalGenForm {
    public final boolean generateFrameIfNotFound;

    public NetherPortalLikeForm(boolean generateFrameIfNotFound) {
        this.generateFrameIfNotFound = generateFrameIfNotFound;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerLevel fromWorld, BlockPos startingPos, ServerLevel toWorld, @Nullable Entity triggeringEntity) {
        if (!NetherPortalGeneration.checkPortalGeneration(fromWorld, startingPos)) {
            return false;
        }
        Predicate<BlockState> areaPredicate = this.getAreaPredicate();
        Predicate<BlockState> thisSideFramePredicate = this.getThisSideFramePredicate();
        Predicate<BlockState> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startingPos, areaPredicate, thisSideFramePredicate);
        if (fromShape == null) {
            return false;
        }
        if (!this.testThisSideShape(fromWorld, fromShape)) {
            return false;
        }
        if (NetherPortalGeneration.isOtherGenerationRunning(fromWorld, fromShape.innerAreaBox.getCenterVec())) {
            return false;
        }
        if (this.generateFrameIfNotFound) {
            for (BlockPos areaPos : fromShape.area) {
                fromWorld.m_46597_(areaPos, Blocks.f_50016_.m_49966_());
            }
        }
        BlockPos toPos = cpg.mapPosition(fromShape.innerAreaBox.getCenter(), fromWorld, toWorld);
        Function<WorldGenRegion, Function<BlockPos.MutableBlockPos, PortalGenInfo>> frameMatchingFunc = this.getFrameMatchingFunc(fromWorld, toWorld, fromShape);
        NetherPortalGeneration.startGeneratingPortal(fromWorld, toWorld, fromShape, toPos, IPGlobal.netherPortalFindingRadius, otherSideFramePredicate, toShape -> this.generateNewFrame(fromWorld, fromShape, toWorld, (BlockPortalShape)toShape), info -> {
            Portal[] result = this.generatePortalEntitiesAndPlaceholder((PortalGenInfo)info);
            cpg.onPortalsGenerated(result);
        }, () -> {
            if (!this.generateFrameIfNotFound) {
                return null;
            }
            return this.getNewPortalPlacement(toWorld, toPos, fromWorld, fromShape, triggeringEntity);
        }, () -> fromShape.frameAreaWithoutCorner.stream().allMatch(bp -> !fromWorld.m_46859_(bp)), frameMatchingFunc);
        return true;
    }

    public Function<WorldGenRegion, Function<BlockPos.MutableBlockPos, PortalGenInfo>> getFrameMatchingFunc(ServerLevel fromWorld, ServerLevel toWorld, BlockPortalShape fromShape) {
        Predicate<BlockState> areaPredicate = this.getAreaPredicate();
        Predicate<BlockState> otherSideFramePredicate = this.getOtherSideFramePredicate();
        BlockPos.MutableBlockPos temp2 = new BlockPos.MutableBlockPos();
        return region -> blockPos -> {
            BlockPortalShape result = fromShape.matchShapeWithMovedFirstFramePos(pos -> areaPredicate.test(region.m_8055_(pos)), pos -> otherSideFramePredicate.test(region.m_8055_(pos)), (BlockPos)blockPos, temp2);
            if (result != null && (fromWorld != toWorld || fromShape.anchor != result.anchor)) {
                return new PortalGenInfo((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, result);
            }
            return null;
        };
    }

    @Nullable
    public PortalGenInfo getNewPortalPlacement(ServerLevel toWorld, BlockPos toPos, ServerLevel fromWorld, BlockPortalShape fromShape, @Nullable Entity triggeringEntity) {
        ServerPlayer player;
        boolean canForcePlace = false;
        if (triggeringEntity instanceof ServerPlayer && (player = (ServerPlayer)triggeringEntity).m_7500_()) {
            canForcePlace = true;
        }
        IntBox airCubePlacement = NetherPortalGeneration.findAirCubePlacement(toWorld, toPos, fromShape.axis, fromShape.totalAreaBox.getSize(), canForcePlace);
        if (!canForcePlace && airCubePlacement == null && triggeringEntity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)triggeringEntity;
            player2.m_5661_((Component)Component.m_237115_((String)"imm_ptl.no_place_to_generate_portal"), false);
        }
        if (airCubePlacement == null) {
            return null;
        }
        BlockPortalShape placedShape = fromShape.getShapeWithMovedTotalAreaBox(airCubePlacement);
        return new PortalGenInfo((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, placedShape);
    }

    public Portal[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        info.generatePlaceholderBlocks();
        return info.generateBiWayBiFacedPortal((EntityType)IPRegistry.GENERAL_BREAKABLE_PORTAL.get());
    }

    public abstract void generateNewFrame(ServerLevel var1, BlockPortalShape var2, ServerLevel var3, BlockPortalShape var4);

    public abstract Predicate<BlockState> getOtherSideFramePredicate();

    public abstract Predicate<BlockState> getThisSideFramePredicate();

    public abstract Predicate<BlockState> getAreaPredicate();

    public boolean testThisSideShape(ServerLevel fromWorld, BlockPortalShape fromShape) {
        return true;
    }
}

